#This script shifts the priority by a value.


#------------------------------- Collect job IDs ---------------------------------------------------

#Frist we create a list of jobs for each priority.
#we could process each job seperately and send each command seperately
#But this is not Deadl... and RR supports sending a command for multiple jobs, which is way faster
#And we get some nice overview for the UI

job_count = rr.jobSelected_count()
jobsByPriority = [ [] for y in range(100)] 
for j in range(job_count):
    job = rr.jobSelected_get(j)
    jobsByPriority[job.priority].append(job.ID)
    #print("added job to prio {}".format(job.priority))

UI_Info="Selected job count by priority:\n\n"



for p in range(100):
    #print("{}: {} jobs".format(p, len(jobsByPriority[p])))
    if len(jobsByPriority[p]) > 0:
        UI_Info= UI_Info + "Prio  {}:    {} jobs\n".format(p,len(jobsByPriority[p])) 
    
    


#------------------------------- Create UI ---------------------------------------------------


myUI= rrGlobal.getGenericUI()
myUI.addItem(rrGlobal.genUIType.label,"infoLabel","")
myUI.setText("infoLabel",UI_Info)

myUI.addItem(rrGlobal.genUIType.label,"labelDivideC","")
myUI.setText("labelDivideC","_________________________________________________________")

myUI.addItem(rrGlobal.genUIType.layoutH,"prioLayout","")

myUI.addItem(rrGlobal.genUIType.label,"labelPrio","prioLayout")
myUI.setText("labelPrio","Shift Priority by")
myUI.addItem(rrGlobal.genUIType.spin,"prioShift","prioLayout")
myUI.setValueMin("prioShift",-100)
myUI.setValueMax("prioShift",100)
myUI.setValue("prioShift",0)


myUI.addItem(rrGlobal.genUIType.label,"labelDivideE","")
myUI.setText("labelDivideE","_________________________________________________________")

myUI.addItem(rrGlobal.genUIType.layoutH,"btnLayout","")
myUI.addItem(rrGlobal.genUIType.closeButton,"Create Job(s)","btnLayout")
myUI.addItem(rrGlobal.genUIType.closeButton,"Abort","btnLayout")


#------------------------------- Execute UI ---------------------------------------------------

myUI.execute()
if (myUI.value("Abort")==1):
    del myUI
    raise rrCleanExit()

shiftValue= myUI.value("prioShift")
del myUI

if (shiftValue==0):
    raise rrCleanExit()
    


#------------------------------- Create job settings and submit ---------------------------------------------------

settings_Value=      rrJob.getClass_SettingsOnly()
settings_ChangeFlag= rrJob.getClass_SettingsOnly()

#any value other than 0 to tell RR to change this setting
settings_ChangeFlag.priority=1


for p in range(100):
    #print("{}: {} jobs".format(p, len(jobsByPriority[p])))
    if len(jobsByPriority[p]) > 0:
        newPrio= p + shiftValue
        if (newPrio < 1):
            newPrio= 1
        if (newPrio > 99):
            newPrio= 99
        settings_Value.priority= newPrio
        
        if not rr.jobModify(jobsByPriority[p], settings_Value, settings_ChangeFlag):
            rrGlobal.messageBox(rrGlobal.logLvL.error, "Error jobModify: " + tcp.errorMessage())
            raise rrCleanExit()


rrGlobal.messageBox(rrGlobal.logLvL.info, "Done")    



